<?php


/**
 * Tour reservation form page.
 */
function _tour_reservation_booking_form($form, $form_state, $prog_id) {
	$settings = variable_get('tour_reservation', array());

	$query = db_select('thtt_m_program','p');
	$query->join('thtt_m_tour', 't', 't.tour_id = p.tour_id');
	$query->join('thtt_m_tour_category', 'c', 't.tour_category_id = c.tour_category_id');
	$query->fields('p')
	->condition('p.prog_id',$prog_id);
	
	$result = $query->execute();
	$progItem = null;
	
	foreach($result as $item) {
		$progItem = $item;
	

		$form['title'] = array(
				'#markup' => '<div id="headline"> <h1>TOUR RESERVATION</h1> </div>'
		);
		$form['excursion'] = array(
				'#markup' => '<div class="col-md-5 col-sm-5 form-label">Excursion: <span class="red">*</span></div><div class="col-md-7 col-sm-7 form-title form-entry">'.$progItem->prog_name.'</div>'
		);
		$form['prog_id'] = array(
				'#type' => 'hidden',
				'#value' => $prog_id,
		);
		
		
		$categoryOption = array();
		
		foreach($result as $item) {
			$categoryOption[$item->tour_category_id] = t($item->tour_category_name);
		}
		
		$numP = array();
		for($i=1; $i<= 20; $i++) {
			$numP[$i] = $i;
		}
		$numO = array();
		for($i=0; $i<= 20; $i++) {
			$numO[$i] = $i;
		}
		$form['adult'] = array(
				'#default_value'  => '',
				'#title'          => t('Number of Party: '),
				'#type' => 'select',
				'#options' => $numP,
				'#default_value' => 1,
				'#required' => TRUE,
		);
	
		$result = db_select('thtt_m_tour_category','a')
		->fields('a', array('tour_category_id','tour_category_name'))
		->execute();
	
		$categoryOption = array();
	
		foreach($result as $item) {
			$categoryOption[$item->tour_category_id] = t($item->tour_category_name);
		}
	
	
		//---------- Get Node list ---------
		$result = db_select('node','a')
		->fields('a', array('nid','title'))
		->execute();
	
		$nodeOption = array();
	
		foreach($result as $item2) {
			$nodeOption[$item2->nid] = t($item2->title);
		}
	
		$default = !empty($form_state['values']['howmany_select']) ? $form_state['values']['howmany_select'] : 1;
	
		$form['howmany_select'] = array(
				'#title' => t('How many checkboxes do you want?'),
				'#type' => 'select',
				'#options' => array(1 => 1, 2 => 2, 3 => 3, 4 => 4),
				'#default_value' => $default,
				'#ajax' => array(
						'callback' => 'ajax_example_autocheckboxes_callback',
						'wrapper' => 'checkboxes-div',
						'method' => 'replace',
						'effect' => 'fade',
				),
		);
			
			
		$form['checkboxes_fieldset'] = array(
				'#title' => t("Generated Checkboxes"),
				// The prefix/suffix provide the div that we're replacing, named by
				// #ajax['wrapper'] above.
				'#prefix' => '',
				'#suffix' => '',
				'#type' => 'fieldset',
				'#description' => t('This is where we get automatically generated checkboxes'),
		);
	
		$form['tour_category_id'] = array(
				'#default_value'  => '',
				'#description'    => t('Tour category'),
				'#title'          => t('Tour Category'),
				'#type'           => 'select',
				'#options'        => $categoryOption,
				'#required' => TRUE,
		);
		$form['nid'] = array(
				'#default_value'  => '',
				'#description'    => t('Link basic page'),
				'#title'          => t('Link basic page'),
				'#type'           => 'select',
				'#options'        => $nodeOption,
				'#required' => TRUE,
		);
		$form['tour_name'] = array(
				'#default_value'  => '',
				'#description'    => t('Tour name'),
				'#title'          => t('Tour name'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
		$form['tour_short_desc'] = array(
				'#default_value'  => '',
				'#description'    => t('Short description'),
				'#title'          => t('Tour short description'),
				'#type'           => 'textarea',
				'#required' => TRUE,
		);
		$form['tour_picture_path'] = array(
				'#default_value'  => '',
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
				'#upload_validators' => array(
						'file_validate_extensions' => array("png jpg jpeg gif"),
				),
		);
		$form['price_adult'] = array(
				'#default_value'  => '0.0',
				'#description'    => t('Original audult price'),
				'#title'          => t('Audult price'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
		$form['price_child'] = array(
				'#default_value'  => '0.0',
				'#description'    => t('Original child price'),
				'#title'          => t('Child price'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
		$form['price_new_adult'] = array(
				'#default_value'  => '0.0',
				'#description'    => t('New audult price'),
				'#title'          => t('New audult price'),
				'#type'           => 'textfield',
		);
		$form['price_new_child'] = array(
				'#default_value'  => '0.0',
				'#description'    => t('New child price'),
				'#title'          => t('New child price'),
				'#type'           => 'textfield',
		);
		$form['currency_cd'] = array(
				'#default_value'  => 'THB',
				'#description'    => t('Currency'),
				'#options'        => array(
						'THB'     => t('THB'),
						'US'      => t('US'),
				),
				'#title'          => t('Currency'),
				'#type'           => 'select',
				'#required' => TRUE,
		);
	
		// Submit button
		$form['submit'] = array(
				'#value'          => t('Save tour'),
				'#type'           => 'submit',
		);
	}
	
	return ($form);
}

/**
 * Validate form
 *
 * @ingroup form
 */
function _tour_reservation_booking_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['price_adult'])) {
		form_set_error('price_adult', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['price_child'])) {
		form_set_error('price_child', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['price_new_adult'])) {
		form_set_error('price_new_adult', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['price_new_child'])) {
		form_set_error('price_new_child', t('Field must be Numeric'));
	}
}

/**
 * Module settings page. Users can set the default layout
 * of their charts.
 *
 * @ingroup form
 */
function _tour_reservation_booking_form_submit($form, &$form_state) {
	$file = file_load($form_state['values']['tour_picture_path']);
	$file->status = FILE_STATUS_PERMANENT;
	file_save($file);

	$nid = db_insert('thtt_m_tour') // Table name no longer needs {}
	->fields(array(
			'tour_cd' => $form_state['values']['tour_cd'],
			'tour_category_id' => $form_state['values']['tour_category_id'],
			'tour_name' => $form_state['values']['tour_name'],
			'tour_short_desc' => $form_state['values']['tour_short_desc'],
			'nid' => $form_state['values']['nid'],
			'tour_picture_path' => $form_state['values']['tour_picture_path'],
			'price_adult' => $form_state['values']['price_adult'],
			'price_child' => $form_state['values']['price_child'],
			'price_new_adult' => $form_state['values']['price_new_adult'],
			'price_new_child' => $form_state['values']['price_new_child'],
			'display_order' => $form_state['values']['display_order'],
			'currency_cd' => $form_state['values']['currency_cd'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->execute();

	//drupal_flush_all_caches();

	// Print a 'OK' message
	drupal_set_message(t('Tour saved'));
	 
	$form_state['redirect'] = 'admin/config/content/package_tour/tour/';
	 
}

